﻿//////////////////////////////////////////////
// FxaaProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "FxaaEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct FxaaProgramIdGenerator
	{
		static unsigned long long generate (const FxaaEffectInfo& info) ;
	} ;

	struct FxaaProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_FXAA_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class FxaaProgramTracker final : public ProgramTracker<FxaaEffectInfo, FxaaProgramIdGenerator, FxaaProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			FxaaProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~FxaaProgramTracker () ;
	} ;
}